<?php

/**
 * This is the model class for table "RodzajBudynku".
 *
 * The followings are the available columns in table 'RodzajBudynku':
 * @property double $id
 * @property string $typ
 */
class RodzajBudynku extends CActiveRecord
{
	const TYPE_AGENCJA_REKLAMOWA = 'agencja reklamowa';

	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return RodzajBudynku the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'RodzajBudynku';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('typ', 'length', 'max'=>64),

			array('id, typ', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'budyneks'=>array(self::HAS_MANY, 'Budynek', 'idRodzajuBudynku'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('RodzajBudynku', 'id'),
			'typ'=>Yii::t('RodzajBudynku', 'typ'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('typ', $this->typ, true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}